% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{loglik}
\alias{loglik}
\title{Expected Complete Data Log-Likelihood Function for Estimation of the Misclassification Model}
\usage{
loglik(param_current, obs_Y_matrix, X, Z, sample_size, n_cat)
}
\arguments{
\item{param_current}{A numeric vector of regression parameters, in the order
\eqn{\beta, \gamma}. The \eqn{\gamma} vector is obtained from the matrix form.
In matrix form, the gamma parameter matrix rows
correspond to parameters for the \code{Y* = 1}
observed outcome, with the dimensions of \code{Z}.
In matrix form, the gamma parameter matrix columns correspond to the true outcome categories
\eqn{j = 1, \dots,} \code{n_cat}. The numeric vector \code{gamma_v} is
obtained by concatenating the gamma matrix, i.e. \code{gamma_v <- c(gamma_matrix)}.}

\item{obs_Y_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{X}{A numeric design matrix for the true outcome mechanism.}

\item{Z}{A numeric design matrix for the observation mechanism.}

\item{sample_size}{Integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{X} or \code{Z}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcome, \code{Y*} can take.}
}
\value{
\code{loglik} returns the negative value of the expected log-likelihood function,
\eqn{ Q = \sum_{i = 1}^N \Bigl[ \sum_{j = 1}^2 w_{ij} \text{log} \{ \pi_{ij} \} + \sum_{j = 1}^2 \sum_{k = 1}^2 w_{ij} y^*_{ik} \text{log} \{ \pi^*_{ikj} \}\Bigr]},
at the provided inputs.
}
\description{
Expected Complete Data Log-Likelihood Function for Estimation of the Misclassification Model
}
