% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBO_weight.R
\name{COMBO_weight}
\alias{COMBO_weight}
\title{Compute E-step for Binary Outcome Misclassification Model Estimated With the EM-Algorithm}
\usage{
COMBO_weight(ystar_matrix, pistar_matrix, pi_matrix, sample_size, n_cat)
}
\arguments{
\item{ystar_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{pistar_matrix}{A numeric matrix of conditional probabilities obtained from
the internal function \code{pistar_compute}. Rows of the matrix correspond to
each subject and to each observed outcome category. Columns of the matrix
correspond to each true, latent outcome category.}

\item{pi_matrix}{A numeric matrix of probabilities obtained from the internal
function \code{pi_compute}. Rows of the matrix correspond to each subject.
Columns of the matrix correspond to each true, latent outcome category.}

\item{sample_size}{An integer value specifying the number of observations in
the sample. This value should be equal to the number of rows of the observed
outcome matrix, \code{ystar_matrix}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcome, \code{Y*}, can take.}
}
\value{
\code{COMBO_weight} returns a matrix of E-step weights for the EM-algorithm,
computed as follows:
\eqn{\sum_{k = 1}^2 \frac{y^*_{ik} \pi^*_{ikj} \pi_{ij}}{\sum_{\ell = 1}^2 \pi^*_{i k \ell} \pi_{i \ell}}}.
Rows of the matrix correspond to each subject. Columns of the matrix correspond
to the true outcome categories \eqn{j = 1, \dots,} \code{n_cat}.
}
\description{
Compute E-step for Binary Outcome Misclassification Model Estimated With the EM-Algorithm
}
