% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPC.R
\name{CPC}
\alias{CPC}
\title{Cluster-Polarization Coefficient}
\usage{
CPC(
  data,
  type,
  k = NULL,
  epsilon = NULL,
  model = FALSE,
  adjust = FALSE,
  cols = NULL,
  clusters = NULL,
  ...
)
}
\arguments{
\item{data}{a numeric vector or \code{n x k} matrix or data frame. If
\code{type = "manual"}, \code{data} must be a matrix containing a vector
identifying cluster membership for each observation, to be passed to
\code{clusters} argument.}

\item{type}{a character string giving the type of clustering method to be used.
See Details.}

\item{k}{the desired number of clusters. Required if \code{type} is one of \code{"hclust"},
\code{"diana"}, \code{"kmeans"}, or \code{"pam"}.}

\item{epsilon}{radius of epsilon neighborhood. Required if \code{type = "dbscan"}.}

\item{model}{a logical indicating whether clustering model output should be
returned. Defaults to \code{FALSE}.}

\item{adjust}{a logical indicating whether the adjusted CPC should be calculated.
Defaults to \code{FALSE}. Note that both CPC and adjusted CPC are automatically
calculated and returned if \code{model = TRUE}.}

\item{cols}{columns of \code{data} to be used in CPC calculation. Only used if
\code{type = "manual"}.}

\item{clusters}{column of \code{data} indicating cluster membership for each
observation. Only used if \code{type = "manual"}.}

\item{...}{arguments passed to other functions.}
}
\value{
If \code{model = TRUE}, \code{CPC()} returns a list with components
containing output from the specified clustering function, all sums of squares, the
CPC, the adjusted CPC, and associated standard errors. If \code{model = FALSE}, \code{CPC()} returns
a numeric vector of length 1 giving the CPC (if \code{adjust = FALSE}) or adjusted CPC (if
\code{adjust = TRUE}).
}
\description{
Implements clustering algorithms and calculates cluster-polarization coefficient.
Contains support for hierarchical clustering, k-means clustering, partitioning
around medoids, density-based spatial clustering with noise, and manual assignment
of cluster membership.
}
\details{
\code{type} must take one of six values: \cr
\code{"hclust"}: agglomerative hierarchical clustering with \code{\link{hclust}()}, \cr
\code{"diana"}: divisive hierarchical clustering with \code{\link{diana}()}, \cr
\code{"kmeans"}: k-means clustering with \code{\link{kmeans}()}, \cr
\code{"pam"}: k-medoids clustering with \code{\link{pam}()}, \cr
\code{"dbscan"}: density-based clustering with \code{\link{dbscan}()}, \cr
\code{"manual"}: no clustering is necessary, researcher has specified cluster assignments.

For all clustering methods, additional arguments to fine-tune clustering
performance, such as the specific algorithm to be used, should be passed to
\code{CPC()} and will be inherited by the specified clustering function. In
particular, if \code{type = "kmeans"}, using a large number of random starts is
recommended. This can be specified with the \code{nstart} argument to
\code{\link{kmeans}()}, passed directly to \code{CPC()}.

If \code{type = "manual"}, \code{data} must contain a vector identifying cluster
membership for each observation, and \code{cols} and \code{clusters} must be
defined.
}
\examples{
data <- matrix(c(rnorm(50, 0, 1), rnorm(50, 5, 1)), ncol = 2, byrow = TRUE)
clusters <- matrix(c(rep(1, 25), rep(2, 25)), ncol = 1)
data <- cbind(data, clusters)

CPC(data[,c(1:2)], "kmeans", k = 2)
CPC(data, "manual", cols = 1:2, clusters = 3)

}
