% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{model2df}
\alias{model2df}
\title{model2df}
\usage{
model2df(model, gather = TRUE, rho = 1, compute.pulled.rates = TRUE)
}
\arguments{
\item{model}{an object of class "CRABS"}

\item{gather}{boolean. Whether to return wide or long data frame}

\item{rho}{the sampling fraction at the present. Used to calculate the pulled speciation rate}

\item{compute.pulled.rates}{whether to compute the pulled rates}
}
\value{
a data frame
}
\description{
model2df
}
\examples{
lambda <- function(t) 2.0 + sin(0.8*t)
mu <- function(t) 1.5 + exp(0.15*t)
times <- seq(from = 0, to = 4, length.out = 1000)
model <- create.model( lambda, mu, times = times)

model2df(model)
}
