% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logscore.R
\name{logscore}
\alias{logscore}
\title{Logarithmic score}
\usage{
logscore(m, ordinal, Y, W, bet, gama)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of covariates for explaining the uncertainty component}

\item{W}{Matrix of covariates for explaining the feeling component}

\item{bet}{Vector of parameters for the uncertainty component, with length NCOL(Y)+1 
to account for an intercept term (first entry of bet)}

\item{gama}{Vector of parameters for the feeling component, with length NCOL(W)+1 
to account for an intercept term (first entry of gama)}
}
\description{
Compute the logarithmic score of a CUB model with covariates both for the uncertainty 
and the feeling parameters.
}
\examples{
data(relgoods)
m<-10
gender<-relgoods[,2]
smoking<-relgoods[,12]
ordinal<-relgoods[,40]
nona<-na.omit(cbind(ordinal,gender,smoking))
ordinal<-nona[,1]
gender<-nona[,2]
smoking<-nona[,3]
bet<-c(-0.45,-0.48)
gama<-c(-0.55,-0.43)
logscore(m, ordinal, Y=smoking, W=gender, bet, gama)
}
\references{
Tutz, G. (2012). \emph{Regression for Categorical Data}, Cambridge University Press, Cambridge
}
\keyword{htest}

