% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Sqrt-class}
\alias{Sqrt-class}
\alias{.Sqrt}
\alias{Sqrt}
\alias{Sqrt}
\alias{validate_args,Sqrt-method}
\alias{to_numeric,Sqrt-method}
\alias{get_data,Sqrt-method}
\alias{sign_from_args,Sqrt-method}
\alias{is_atom_convex,Sqrt-method}
\alias{is_atom_concave,Sqrt-method}
\alias{is_incr,Sqrt-method}
\alias{is_decr,Sqrt-method}
\alias{is_quadratic,Sqrt-method}
\alias{graph_implementation,Sqrt-method}
\title{The Sqrt class.}
\usage{
Sqrt(x)

\S4method{validate_args}{Sqrt}(object)

\S4method{to_numeric}{Sqrt}(object, values)

\S4method{get_data}{Sqrt}(object)

\S4method{sign_from_args}{Sqrt}(object)

\S4method{is_atom_convex}{Sqrt}(object)

\S4method{is_atom_concave}{Sqrt}(object)

\S4method{is_incr}{Sqrt}(object, idx)

\S4method{is_decr}{Sqrt}(object, idx)

\S4method{is_quadratic}{Sqrt}(object)

\S4method{graph_implementation}{Sqrt}(object, arg_objs, size, data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} object.}

\item{object}{A \linkS4class{Sqrt} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise square root \eqn{\sqrt{x}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Verification of arguments happens during initialization.

\item \code{to_numeric}: The elementwise square root of the input value.

\item \code{get_data}: A list containing the output of \code{pow_mid}.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is not convex.

\item \code{is_atom_concave}: The atom is concave.

\item \code{is_incr}: The atom is weakly increasing.

\item \code{is_decr}: The atom is not weakly decreasing.

\item \code{is_quadratic}: Is \code{x} constant?

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} object.}
}}

