% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{CumMax-class}
\alias{CumMax-class}
\alias{.CumMax}
\alias{CumMax}
\alias{to_numeric,CumMax-method}
\alias{.grad,CumMax-method}
\alias{.column_grad,CumMax-method}
\alias{dim_from_args,CumMax-method}
\alias{sign_from_args,CumMax-method}
\alias{get_data,CumMax-method}
\alias{is_atom_convex,CumMax-method}
\alias{is_atom_concave,CumMax-method}
\alias{is_incr,CumMax-method}
\alias{is_decr,CumMax-method}
\title{The CumMax class.}
\usage{
CumMax(expr, axis = 2)

\S4method{to_numeric}{CumMax}(object, values)

\S4method{.grad}{CumMax}(object, values)

\S4method{.column_grad}{CumMax}(object, value)

\S4method{dim_from_args}{CumMax}(object)

\S4method{sign_from_args}{CumMax}(object)

\S4method{get_data}{CumMax}(object)

\S4method{is_atom_convex}{CumMax}(object)

\S4method{is_atom_concave}{CumMax}(object)

\S4method{is_incr}{CumMax}(object, idx)

\S4method{is_decr}{CumMax}(object, idx)
}
\arguments{
\item{expr}{An \linkS4class{Expression}.}

\item{axis}{A numeric vector indicating the axes along which to apply the function. For a 2D matrix, \code{1} indicates rows, \code{2} indicates columns, and \code{c(1,2)} indicates rows and columns.}

\item{object}{A \linkS4class{CumMax} object.}

\item{values}{A list of numeric values for the arguments}

\item{value}{A numeric value.}

\item{idx}{An index into the atom.}
}
\description{
This class represents the cumulative maximum of an expression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(CumMax)}: The cumulative maximum along the axis.

\item \code{.grad(CumMax)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.column_grad(CumMax)}: Gives the (sub/super)gradient of the atom w.r.t. each column variable

\item \code{dim_from_args(CumMax)}: The dimensions of the atom determined from its arguments.

\item \code{sign_from_args(CumMax)}: The (is positive, is negative) sign of the atom.

\item \code{get_data(CumMax)}: Returns the axis along which the cumulative max is taken.

\item \code{is_atom_convex(CumMax)}: Is the atom convex?

\item \code{is_atom_concave(CumMax)}: Is the atom concave?

\item \code{is_incr(CumMax)}: Is the atom weakly increasing in the index?

\item \code{is_decr(CumMax)}: Is the atom weakly decreasing in the index?

}}
\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression}.}

\item{\code{axis}}{A numeric vector indicating the axes along which to apply the function. For a 2D matrix, \code{1} indicates rows, \code{2} indicates columns, and \code{c(1,2)} indicates rows and columns.}
}}

