% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{env_get}
\alias{env_get}
\title{Envelope Estimator for Log-Spectral Regression}
\usage{
env_get(X, f, frq, nbase)
}
\arguments{
\item{X}{A numeric matrix of predictors (N × p).}

\item{f}{A numeric matrix of cepstral coefficients (N × nbase).}

\item{frq}{Numeric vector of frequencies in \code{[0,1]}.}

\item{nbase}{Number of Fourier basis functions.}
}
\value{
A list containing:
\describe{
\item{\code{alph}}{Intercept vector.}
\item{\code{bet}}{Envelope regression coefficient matrix.}
\item{\code{spechat}}{Estimated smoothed log-spectra.}
\item{\code{res}}{Residuals from envelope model.}
}
}
\description{
Fits an envelope regression model to predict cepstral coefficients from covariates.
}
\examples{
library(Renvlp)

set.seed(123)
frq <- seq(0, 1, length.out = 16)[2:8]
n <- 20
p <- 3
nbase <- 5
X <- matrix(rnorm(n * p), n, p)
f <- matrix(rnorm(n * nbase), n, nbase)

u_max <- min(ncol(X), ncol(f))
cv_errors <- numeric(u_max)
for (j in 1:u_max) {
  cv_errors[j] <- cv.xenv(X, f, j, m = 5, nperm = 50)
}
optimal_u <- which.min(cv_errors)

env_result <- env_get(X, f, frq, nbase = nbase)
}
