% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_StParm.R
\name{add_StParm}
\alias{add_StParm}
\title{Add Structural parameter into PML models Dosepoints}
\usage{
add_StParm(
  PMLParametersSets,
  StParmName,
  Type = "LogNormal",
  State = "Present",
  ThetaStParm = list(),
  OmegaStParm = list(),
  Covariates = list(),
  PMLStructures = NULL,
  DosepointArgName = character()
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{StParmName}{Character specifying the name of the structural parameter
to be added.}

\item{Type}{Character specifying the type of the structural parameter. Options are
\itemize{
\item \code{LogNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV * wt^dVdwt * exp(nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{LogNormal1} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = (tvV + wt*dVdwt) * exp(nV + nVx0*( Occasion==0) + nVx1*( Occasion==1)))}
\itemize{
\item \code{LogNormal2} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = exp(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occason==1)))}
\itemize{
\item \code{LogitNormal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = ilogit(tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1)))}
\itemize{
\item \code{Normal} The PML statement of the structural parameter will look like the following:
}

\code{stparm(V = tvV + wt*dVdwt + nV + nVx0*(Occasion==0) + nVx1*(Occasion==1))}}

\item{State}{character string that indicates the presence of the structural
parameter. Options are:
\itemize{
\item \code{None} The structural parameter does not exist in the specified \code{PMLStructures}.
\item \code{Present} The structural parameter exists in the specified \code{PMLStructures} (the default).
\item \code{Searched} The presence of the structural parameter  is searched.
}}

\item{ThetaStParm}{A Theta class instance inside the structural parameter. If
not given, the associated Theta will be automatically created with its name
set to "tv" + \code{StParmName}.}

\item{OmegaStParm}{An Omega class instance inside the structural parameter.
If not given, the associated Omega will be automatically created with its
name set to "n" + \code{StParmName}}

\item{Covariates}{A list of covariates (\code{Covariate} instances) that should be
included in the structural parameter statement.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures to whichthe structural parameter will be added. For the naming
convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}

\item{DosepointArgName}{Character specifying the name of the argument in the
\code{\link[=Dosepoint]{Dosepoint()}} instance to add/update the associated structural parameter.
Options are \code{bioavail}, \code{rate}, \code{duration}, \code{tlag}. Not applicable for
custom models}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Add Structural parameter into PML models Dosepoints
}
\details{
\itemize{
\item only special \code{\link[=Dosepoint]{Dosepoint()}} related structural parameters could be
added to built-in models (i.e. created using either \code{create_ModelPD()} or
\code{create_modelPK()}. Due to ambiguity of situation when a structural parameter
is added with \code{State == 'None'}, a warning is given for such cases.
\item A structural parameter could be added to the custom model if it not presented in the model yet
(as a custom or built-in structural parameter).
}
}
\examples{
PMLParametersSets <-
  get_PMLParametersSets(CompartmentsNumber = c(1, 2, 3))

# add Rate structural parameter for all PMLModels
PMLParametersSetsVModDuration <-
 add_StParm(PMLParametersSets,
            StParmName = "Duration",
            ThetaStParm = Theta("tvD",
                          InitialEstimates = 2),
            OmegaStParm = Omega(Name = "nD",
                                State = "Searched"),
            DosepointArgName = "duration")

}
\seealso{
\code{\link[=Dosepoint]{Dosepoint()}} \code{\link[=list_StParms]{list_StParms()}}

Functions used for StParm specification: 
\code{\link{StParm}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_StParm}()},
\code{\link{modify_StParmCustom}()},
\code{\link{remove_StParm}()}
}
\concept{StParms}
