% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_SimParams.R
\name{specify_SimParams}
\alias{specify_SimParams}
\title{Specify engine parameters for model simulation}
\usage{
specify_SimParams(
  numReplicates = 100L,
  seed = 1234L,
  sort = FALSE,
  ODE = c("MatrixExponent", "DVERK", "DOPRI5", "AutoDetect", "Stiff"),
  rtolODE = 1e-06,
  atolODE = 1e-06,
  maxStepsODE = 50000L
)
}
\arguments{
\item{numReplicates}{Integer; Number of replicates to simulate the model}

\item{seed}{Integer; Random number generator seed}

\item{sort}{Logical; Specifying whether or not to sort the input data by
subject and time values. Default is \code{TRUE}.}

\item{ODE}{Character; Specifying the solver used to numerically solve
Ordinary Differential Equations (ODEs). Options are
\itemize{
\item \code{MatrixExponent} (the default),
\item \code{DVERK},
\item \code{DOPRI5},
\item \code{AutoDetect},
\item \code{Stiff}.
}

Note: both \code{DVERK} and \code{DOPRI5} are non-stiff solvers. NLME will
automatically switches to \code{DVERK} if ODEs are nonlinear.}

\item{rtolODE}{Numeric; Specifying relative tolerance for the ODE solver.
Not applicable when \code{ODE == MatrixExponent}.}

\item{atolODE}{Numeric; Specifying absolute tolerance for the ODE solver.}

\item{maxStepsODE}{Numeric; Specifying maximum number of allowable steps or
function evaluations for the ODE solver.}
}
\value{
Character
}
\description{
Use to define engine parameters for model simulation.
}
\examples{
SimArgs1 <- specify_SimParams()

SimArgs2 <-
  specify_SimParams(
    numReplicates = 100,
    seed = 1,
    ODE = "DVERK")

}
\seealso{
\code{\link[=write_ModelTemplateTokens]{write_ModelTemplateTokens()}}, \code{\link[=specify_EngineParams]{specify_EngineParams()}}, \code{\link[=Table]{Table()}}
}
