% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_point_analyzer_function.R
\name{change_point_analyzer}
\alias{change_point_analyzer}
\title{change_point_analyzer}
\usage{
change_point_analyzer(
  x,
  labels = NA,
  n_bootstraps = 1000,
  min_candidate_conf = 0.5,
  min_tbl_conf = 0.9,
  CI = 0.95
)
}
\arguments{
\item{x}{a numeric vector}

\item{labels}{a vector the same length as \code{x}. Will generate labels for the change points in the output dataframe.}

\item{n_bootstraps}{an integer value. Determines the number of bootstraps when calculating the change confidence level.}

\item{min_candidate_conf}{a value between 0 and 1. The minimum change confidence level to become a candidate change point before re-estimation and backwards elimination.}

\item{min_tbl_conf}{a value between 0 and 1. The minimum change confidence level below which a candidate change point will be eliminated after re-estimation and backwards elimination.}

\item{CI}{a value between 0 and 1. The value of the confidence interval.}
}
\value{
a dataframe containing the change points, their confidence levels, and other relevant information
}
\description{
a simple implementation of the change in mean detection \href{https://variation.com/wp-content/uploads/change-point-analyzer/change-point-analysis-a-powerful-new-tool-for-detecting-changes.pdf}{methods} developed by Wayne Taylor and utilized in his \href{https://variation.com/product/change-point-analyzer/}{Change Point Analyzer} software. The package recursively uses the 'MSE' change point calculation to identify candidate change points. Taylor's backwards elimination process is then employed to come up with a final set of change points.
}
\examples{
x <- US_Trade_Deficit$deficit_billions
label_vals <- US_Trade_Deficit$date

change_point_analyzer(x)

change_point_analyzer(x, label = label_vals)

change_point_analyzer(x, label = label_vals, n_bootstraps = 10000)

change_point_analyzer(x, label = label_vals, min_candidate_conf = 0.66,  min_tbl_conf = 0.95)
}
\references{
\href{https://variation.com/wp-content/uploads/change-point-analyzer/change-point-analysis-a-powerful-new-tool-for-detecting-changes.pdf}{Taylor, W. A. (2000). Change-point analysis: a powerful new tool for detecting changes.}
}
