% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfX_ChiSquared.R
\name{cfX_ChiSquared}
\alias{cfX_ChiSquared}
\title{Characteristic function of Noncentral Chi-Squared distribution}
\usage{
cfX_ChiSquared(t, df, npc = 0)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{df}{degrees of freedom}

\item{npc}{non-centrality parameter, default value = 0}
}
\value{
characteristic function cf(t) of the CHI-SUQARED distribution
}
\description{
cfX_ChiSquared(t, df, ncp = 0) evaluates the characteristic function cf(t) of
the Chi-Squared distribution with the parameter df (degrees of freedom, df > 0)
and npc (non-centrality, \eqn{npc \ge 0}), i.e.

cfX_ChiSquared(t, df, npc) = exp((i*npc*t)/(1 - 2it)) / (1 - 2it)^(df/2)
}
\examples{
## EXAMPLE1 (CF of the ChiSquared distribution with df = 1)
df <- 1
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfX_ChiSquared(t, df), t, title = "CF of the Chi-squared distribution with df = 1")

## EXAMPLE2 (PDF/CDF of the ChiSquared distribution with df = 3)
df <- 3
prob <- c(0.9, 0.95, 0.99)
cf <- function(t)
  cfX_ChiSquared(t, df)
x <- seq(-0, 15, length.out = 101)
result <- cf2DistGP(cf,
                    x,
                    prob,
                    xMin = 0,
                    xMax = 22,
                    N = 2 ^ 14)

## EXAMPLE3 (PDF/CDF of the compound Binomial-ChiSquared distribution)
n <- 25
p <- 0.3
df <- 3
prob <- c(0.9, 0.95, 0.99)
cfX <- function(t)
  cfX_ChiSquared(t, df)
cf <- function(t)
  cfN_Binomial(t, n, p, cfX)
x <- seq(-0, 80, length.out = 501)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)

## EXAMPLE4 (CF of the ChiSquared distribution with df = 1, npc = 2)
df <- 1
npc <- 2
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfX_ChiSquared(t, df, npc), t, title = "CF of the Chi-squared distribution with df = 1, npc = 2")

## EXAMPLE5 (PDF/CDF of the ChiSquared distribution with df = 3, npc = 2)
df <- 3
npc <- 2
prob <- c(0.9, 0.95, 0.99)
cf <- function(t)
  cfX_ChiSquared(t, df, npc)
x <- seq(-0, 15, length.out = 101)
result <- cf2DistGP(cf, x, prob, N = 2 ^ 14)

## EXAMPLE6 (PDF/CDF of the compound Binomial-ChiSquared distribution)
n <- 25
p <- 0.3
df <- 3
npc <- 2
prob <- c(0.9, 0.95, 0.99)
cfX <- function(t)
  cfX_ChiSquared(t, df, npc)
cf <- function(t)
  cfN_Binomial(t, n, p, cfX)
x <- seq(-0, 80, length.out = 501)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)

}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Noncentral_chi-squared_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}
}

