% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeGroup.R
\name{removeGroup}
\alias{removeGroup}
\title{Remove a Group from a Spectra or Spectra2D Object}
\usage{
removeGroup(spectra, rem.group)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[ChemoSpec]{Spectra}} or
\code{\link[ChemoSpec2D]{Spectra2D}}.}

\item{rem.group}{A character vector (handled as a regex) giving the groups to be removed.}
}
\value{
An object of S3 class \code{\link[ChemoSpec]{Spectra}} or \code{\link[ChemoSpec2D]{Spectra2D}}.
}
\description{
Removes specified groups from a \code{\link[ChemoSpec]{Spectra}} or
\code{\link[ChemoSpec2D]{Spectra2D}} object.
}
\details{
This function will report if extra data elements are found.  These will
probably need to be edited manually.  The indices reported to the console
can be helpful in this regard.

If \code{rem.group} is a character vector, the sample
names are grepped for the corresponding values.  Remember that the
grepping process is greedy, i.e. grepping for "XY" find not only "XY" but
also "XYZ".

Unused levels in \code{$groups} are dropped.
}
\examples{
if (checkForPackageWithVersion("ChemoSpec", "5.1")) {
  library("ChemoSpec")
  data(SrE.IR)

  sumGroups(SrE.IR)
  SrE.IRa <- removeGroup(SrE.IR, rem.group = "pSrE")
  sumGroups(SrE.IRa)
}

if (checkForPackageWithVersion("ChemoSpec2D", "0.3")) {
  library("ChemoSpec2D")
  data(MUD1)

  sumGroups(MUD1)
  MUD1a <- removeGroup(MUD1, rem.group = "Ether")
  sumGroups(MUD1a)
}
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{utilities}
