/*
 * Decompiled with CFR 0.152.
 */
package core.stats;

import core.lattice.Lattice;
import core.lattice.LatticeNode;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;

public class EntropyComputer {
    public static long nbCellsEverParsed;
    HashMap<BitSet, Double> lookup = new HashMap();
    double[] partialEntropy;
    Lattice lattice;
    int nbInstances;

    public EntropyComputer(int nbInstances, Lattice lattice) {
        this.lattice = lattice;
        this.nbInstances = nbInstances;
        this.lookup.put(new BitSet(lattice.getNbVariables()), 0.0);
        this.partialEntropy = new double[this.nbInstances + 1];
        double lnN = FastMath.log((double)nbInstances);
        this.partialEntropy[0] = 0.0;
        int i = 1;
        while (i < this.partialEntropy.length) {
            this.partialEntropy[i] = (double)i * (FastMath.log((double)i) - lnN);
            ++i;
        }
        nbCellsEverParsed = 0L;
    }

    public EntropyComputer(Lattice lattice) {
        this.lattice = lattice;
        this.nbInstances = this.lattice.getNbInstances();
        this.lookup.put(new BitSet(lattice.getNbVariables()), 0.0);
        this.partialEntropy = new double[this.nbInstances + 1];
        double lnN = FastMath.log((double)this.nbInstances);
        this.partialEntropy[0] = 0.0;
        int i = 1;
        while (i < this.partialEntropy.length) {
            this.partialEntropy[i] = (double)i * (FastMath.log((double)i) - lnN);
            ++i;
        }
        nbCellsEverParsed = 0L;
    }

    public Double computeEntropy(BitSet clique) {
        Double computedEntropy = this.lookup.get(clique);
        if (computedEntropy != null) {
            return computedEntropy;
        }
        double entropy = 0.0;
        LatticeNode node = this.lattice.getNode(clique);
        int nbCells = node.getNbCells();
        nbCellsEverParsed += (long)nbCells;
        int i = 0;
        while (i < nbCells) {
            int O = node.getMatrixCell(i);
            entropy += this.partialEntropy[O];
            ++i;
        }
        entropy /= (double)this.nbInstances;
        this.lookup.put(clique, entropy *= -1.0);
        return entropy;
    }

    public int getNbInstances() {
        return this.nbInstances;
    }

    public int getNbVariables() {
        return this.lattice.getNbVariables();
    }

    public int getSizeLookup() {
        return this.lookup.size();
    }
}

