/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.factor;

import java.util.Arrays;
import org.eclipse.recommenders.jayes.factor.Cut;
import org.eclipse.recommenders.jayes.factor.arraywrapper.DoubleArrayWrapper;
import org.eclipse.recommenders.jayes.factor.arraywrapper.IArrayWrapper;
import org.eclipse.recommenders.jayes.factor.opcache.DivisionCache;
import org.eclipse.recommenders.jayes.factor.opcache.ModuloCache;
import org.eclipse.recommenders.jayes.util.MathUtils;

public abstract class AbstractFactor
implements Cloneable {
    protected int[] dimensions = new int[0];
    protected int[] dimensionIDs = new int[0];
    protected IArrayWrapper values = new DoubleArrayWrapper(0.0);
    protected int[] selections = new int[0];
    protected Cut cut = new Cut(this);
    private boolean isCutValid = false;
    private boolean isLogScale = false;

    public abstract void copyValues(IArrayWrapper var1);

    public abstract int[] prepareMultiplication(AbstractFactor var1);

    protected abstract int getRealPosition(int var1);

    public abstract void fill(double var1);

    public void setValues(IArrayWrapper values) {
        this.values = values;
        assert (MathUtils.product(this.dimensions) == values.length());
    }

    public IArrayWrapper getValues() {
        return this.values;
    }

    public double getValue(int i) {
        return this.values.getDouble(this.getRealPosition(i));
    }

    public void setDimensions(int ... dimensions) {
        this.dimensions = Arrays.copyOf(dimensions, dimensions.length);
        this.selections = new int[dimensions.length];
        this.resetSelections();
        int length = MathUtils.product(dimensions);
        if (length > this.values.length()) {
            this.values.newArray(length);
        }
        this.dimensionIDs = Arrays.copyOf(this.dimensionIDs, dimensions.length);
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensionIDs(int ... ids) {
        this.dimensionIDs = (int[])ids.clone();
    }

    public int[] getDimensionIDs() {
        return this.dimensionIDs;
    }

    protected int getDimensionFromID(int id) {
        int i = 0;
        while (i < this.dimensionIDs.length) {
            if (this.dimensionIDs[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void select(int dimensionID, int index) {
        int dim = this.getDimensionFromID(dimensionID);
        if (this.selections[dim] != index) {
            this.selections[dim] = index;
            this.isCutValid = false;
        }
    }

    public void resetSelections() {
        Arrays.fill(this.selections, -1);
        this.isCutValid = false;
    }

    public void setLogScale(boolean isLogScale) {
        this.isLogScale = isLogScale;
    }

    public boolean isLogScale() {
        return this.isLogScale;
    }

    @Deprecated
    public double[] marginalizeAllBut(int sumDimensionID) {
        this.validateCut();
        if (sumDimensionID == -1) {
            sumDimensionID = this.dimensionIDs[this.dimensionIDs.length - 1];
        }
        int sumDimension = this.getDimensionFromID(sumDimensionID);
        double[] result = new double[this.dimensions[sumDimension]];
        int divisor = MathUtils.productOfRange(this.dimensions, sumDimension + 1, this.dimensions.length);
        DivisionCache division = new DivisionCache(divisor);
        this.sumToBucket(this.cut, 0, division, new ModuloCache(result.length), result);
        return result;
    }

    private void sumToBucket(Cut cut, int offset, DivisionCache division, ModuloCache modulo, double[] result) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            int i = cut.getStart() + offset;
            while (i < last) {
                int targetPos;
                int j = this.getRealPosition(i);
                int n = targetPos = modulo.apply(division.apply(i));
                result[n] = result[n] + this.values.getDouble(j);
                i += cut.getStepSize();
            }
        } else {
            Cut c = cut.getSubCut();
            int i = 0;
            while (i < cut.getLength()) {
                this.sumToBucket(c, offset + i, division, modulo, result);
                i += cut.getSubtreeStepsize();
            }
        }
    }

    public void multiplyCompatible(AbstractFactor compatible) {
        int[] positions = this.prepareMultiplication(compatible);
        this.multiplyPrepared(compatible.values, positions);
    }

    public void multiplyPrepared(IArrayWrapper compatibleValues, int[] positions) {
        this.validateCut();
        if (!this.isLogScale) {
            this.multiplyPrepared(this.cut, 0, compatibleValues, positions);
        } else {
            this.multiplyPreparedLog(this.cut, 0, compatibleValues, positions);
        }
    }

    private void multiplyPrepared(Cut cut, int offset, IArrayWrapper compatibleValues, int[] positions) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            int i = cut.getStart() + offset;
            while (i < last) {
                int j = this.getRealPosition(i);
                this.values.mulAssign(j, compatibleValues, positions[j]);
                i += cut.getStepSize();
            }
        } else {
            Cut c = cut.getSubCut();
            int i = 0;
            while (i < cut.getLength()) {
                this.multiplyPrepared(c, offset + i, compatibleValues, positions);
                i += cut.getSubtreeStepsize();
            }
        }
    }

    public void sumPrepared(IArrayWrapper compatibleFactorValues, int[] preparedOperation) {
        this.validateCut();
        compatibleFactorValues.fill(0.0f);
        if (!this.isLogScale) {
            this.sumPrepared(this.cut, 0, compatibleFactorValues, preparedOperation);
        } else {
            this.sumPreparedLog(compatibleFactorValues, preparedOperation);
        }
    }

    private void sumPrepared(Cut cut, int offset, IArrayWrapper compatibleFactorValues, int[] positions) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            int i = cut.getStart() + offset;
            while (i < last) {
                int j = this.getRealPosition(i);
                compatibleFactorValues.addAssign(positions[j], this.values, j);
                i += cut.getStepSize();
            }
        } else {
            Cut c = cut.getSubCut();
            int i = 0;
            while (i < cut.getLength()) {
                this.sumPrepared(c, offset + i, compatibleFactorValues, positions);
                i += cut.getSubtreeStepsize();
            }
        }
    }

    private void sumPreparedLog(IArrayWrapper compatibleFactorValues, int[] positions) {
        double max = this.findMax(this.cut, 0, 0.0);
        this.sumPreparedLog(this.cut, 0, compatibleFactorValues, positions, max);
        int i = 0;
        while (i < compatibleFactorValues.length()) {
            compatibleFactorValues.set(i, Math.log(compatibleFactorValues.getDouble(i)) + max);
            ++i;
        }
    }

    private double findMax(Cut cut, int offset, double max) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            int i = cut.getStart() + offset;
            while (i < last) {
                int j = this.getRealPosition(i);
                if (this.values.getDouble(j) != Double.NEGATIVE_INFINITY && Math.abs(this.values.getDouble(j)) > Math.abs(max)) {
                    max = this.values.getDouble(j);
                }
                i += cut.getStepSize();
            }
        } else {
            Cut c = cut.getSubCut();
            int i = 0;
            while (i < cut.getLength()) {
                double pot = this.findMax(c, offset + i, max);
                if (pot != Double.NEGATIVE_INFINITY && Math.abs(pot) > Math.abs(max)) {
                    max = pot;
                }
                i += cut.getSubtreeStepsize();
            }
        }
        return max;
    }

    private void sumPreparedLog(Cut cut, int offset, IArrayWrapper compatibleFactorValues, int[] positions, double max) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            int i = cut.getStart() + offset;
            while (i < last) {
                int j = this.getRealPosition(i);
                compatibleFactorValues.addAssign(positions[j], Math.exp(this.values.getDouble(j) - max));
                i += cut.getStepSize();
            }
        } else {
            Cut c = cut.getSubCut();
            int i = 0;
            while (i < cut.getLength()) {
                this.sumPreparedLog(c, offset + i, compatibleFactorValues, positions, max);
                i += cut.getSubtreeStepsize();
            }
        }
    }

    private void multiplyPreparedLog(Cut cut, int offset, IArrayWrapper compatibleValues, int[] positions) {
        if (cut.getSubCut() == null) {
            int last = cut.getEnd() + offset;
            int i = cut.getStart() + offset;
            while (i < last) {
                int j = this.getRealPosition(i);
                this.values.addAssign(j, compatibleValues, positions[j]);
                i += cut.getStepSize();
            }
        } else {
            Cut c = cut.getSubCut();
            int i = 0;
            while (i < cut.getLength()) {
                this.multiplyPreparedLog(c, offset + i, compatibleValues, positions);
                i += cut.getSubtreeStepsize();
            }
        }
    }

    protected void validateCut() {
        if (!this.isCutValid) {
            this.cut.initialize();
            this.isCutValid = true;
        }
    }

    public AbstractFactor clone() {
        AbstractFactor f = null;
        try {
            f = (AbstractFactor)super.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        f.values = this.values.clone();
        f.selections = (int[])this.selections.clone();
        f.cut = new Cut(f);
        f.isCutValid = false;
        return f;
    }

    public void multiplyCompatibleToLog(AbstractFactor factor) {
        int[] positions = this.prepareMultiplication(factor);
        int i = 0;
        while (i < this.values.length()) {
            this.values.addAssign(i, Math.log(factor.values.getDouble(positions[i])));
            ++i;
        }
    }

    public abstract int getOverhead();
}

