% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choR.R
\name{ChoR.Budget}
\alias{ChoR.Budget}
\title{Call to the budget chordalysis algorithm.}
\usage{
ChoR.Budget(x, pValueThreshold = 0.05, budgetShare = 0.01, card = NULL)
}
\arguments{
\item{x}{A dataframe with categorical data; column names are the name of the attributes.}

\item{pValueThreshold}{A double value, minimum p-value for statistical consistency (commonly 0.05)}

\item{budgetShare}{A double value, share of the statistical budget to consume at each step (>0 and <=1; 0.01 seems like a reasonable value for most datasets)}

\item{card}{A vector containing the cardinality of the attributes (position wise).}
}
\value{
A Chordalysis object. Use \code{ChoR.as.*} functions to access the result.
}
\description{
Searches a statistically significant decomposable model to explain a dataset using Prioritized Chordalysis.
}
\details{
Call the Budget chordalysis function on the dataframe x. The optionnal card argument can provide a vector
of cardinalities for each attribute (i.e. column) of the dataframe. If absent, the cardinalities are computed
from the dataframe, but not accurate if some possible values never show up. See papers
"Scaling log-linear analysis to high-dimensional data, ICDM 2013",
"Scaling log-linear analysis to datasets with thousands of variables, SDM 2015", and
"A multiple test correction for streams and cascades of statistical hypothesis tests, KDD 2016" for more details.
}
\examples{
\dontrun{ res = ChoR.Budget(data) }
\dontrun{ res = ChoR.Budget(data, budgetShare=0.0) }
\dontrun{ res = ChoR.Budget(data, 0.05, card = c(3, 5, 4, 4, 3, 2, 3, 3)) }
}
