% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_qualis.R
\name{extract_qualis}
\alias{extract_qualis}
\title{Extract QUALIS information}
\usage{
extract_qualis(lattes.list, years, qualis.file, isComputerScience = FALSE,
  output.file = c("csv", "xlsx"), plotQualis = TRUE,
  qualis.extract = NULL, plot.width = 16, plot.height = 8,
  plot.units = "in", plot.res = 300, plot.text.size = 18)
}
\arguments{
\item{lattes.list}{a Lattes list object created using \code{\link[=lattes_to_list]{lattes_to_list()}}}

\item{years}{integer vector with years to be extracted from lattes.list}

\item{qualis.file}{CSV file containing the ranking of journals according to
the QUALIS classification system for a certain area. See \code{Qualis File} for details.}

\item{isComputerScience}{logical flag to indicate if the relevant Qualis file
is related to the "Computer Science" area (in which case conferences also receive
QUALIS ranks)}

\item{output.file}{type of file to output (xlsx or csv).}

\item{plotQualis}{logical flag, should a plot be generated?}

\item{qualis.extract}{name of the qualis extract used (optional, for the plot only)}

\item{plot.width, plot.height, plot.units, plot.res, plot.text.size}{graphical parameters}
}
\value{
This routine returns nothing.
It generates one \strong{.xlsx} or \strong{csv} file for each year in \code{years},
as well as a summary plot per year (as a png file), if \code{plotQualis = TRUE}
}
\description{
Summarize production as classified by a given QUALIS extract
}
\section{Qualis File}{

The qualis file must be a CSV file with commas as separators and UTF-8
encoding. To ensure these properties, follow the steps:
\itemize{
\item Generate the relevant file from
\url{https://sucupira.capes.gov.br/sucupira/public/consultas/coleta/veiculoPublicacaoQualis/listaConsultaGeralPeriodicos.jsf},
selecting only the fields \emph{Evento de Classificacao} and \emph{Area de Avaliacao}
(leave the others blank).
\item Download the resulting \strong{xls} file.
\item Open the file using your reader of choice, select all and copy
\item Open a new spreadsheet on Google Docs, \url{https://docs.google.com/spreadsheets/u/0/}
\item Paste everything into the Google Docs Spreadsheet
\item Download the resulting file as a comma-separated file (\strong{File} -> \strong{Download as} -> \strong{Comma-separated values (.csv, current sheet)})
}
}

