% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWaterUse.R
\name{getWaterUse}
\alias{getWaterUse}
\title{Gather time series of water use data}
\usage{
getWaterUse(states, counties, years = "ALL")
}
\arguments{
\item{states}{list of state abbreviations}

\item{counties}{list of county name lists for each state}

\item{years}{list of years of available data}
}
\value{
list of dataframes of water withdrawals (MGD) by use category, 
one for each water source and quality:
 \item{swf}{surface water, fresh}
 \item{gwf}{groundwater, fresh}
 \item{sws}{surface water, saline}
 \item{gws}{groundwater, saline}
}
\description{
This function gathers and summarizes water use data from USGS NWIS by county,  
year, source (surface or groundwater) and quality (fresh or saline)
}
\examples{
wu <- getWaterUse(c('IL'), c('Cook', 'DeKalb'))
}
