% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPrimersRemove.R
\name{TwoPrimerRemove}
\alias{TwoPrimerRemove}
\title{Clean biological secuences of two primers}
\usage{
TwoPrimerRemove(SEQs, PrimerF, PrimerR)
}
\arguments{
\item{SEQs}{file with fasta format containing biological sequences that are to be cleaned.}

\item{PrimerF}{dnastring or file with fasta format containing the foward primer/vector sequences to be removed.}

\item{PrimerR}{dnastring or file with fasta format containing the reverse primer/vector sequences to be removed.}
}
\value{
clean biological sequences
}
\description{
Clean biological sequences of two restriction enzyme primers or cloning vectors.
}
\examples{
SEQ1 = DNAString("AATCG")
SEQ2 = DNAString("TT")
SEQ3 = DNAString("CG")
TwoPrimerRemove (SEQ1,SEQ2,SEQ3)
}
\author{
Florencia I Pozzi, Gisela Y. Green, Ivana G. Barbona, Gustavo R. Rodriguez, Silvina A. Felitti
}
