% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDD.R
\name{GDD}
\alias{GDD}
\title{Growing Degree Days}
\usage{
GDD(object, day.one = NULL, degree.days = NULL, base = NULL,
  span = NULL, ...)
}
\arguments{
\item{object}{a numeric vector of geographic coordinates (lonlat) or
an array with two dimensions containing the temperature data;
1st dimension contains the day temperature and 2nd dimension the night temperature.
When lonlat is used, the function makes a call to
\code{nasapower::get_power} to fetch and concatenate environmental data from NASA POWER
(\url{https://power.larc.nasa.gov/})}

\item{day.one}{a vector of class 'Date' for the starting date to capture the environmental data}

\item{degree.days}{an integer for the degree days required by the crop (look at the physiology of the focal crop)}

\item{base}{an integer for the base temperature. Set 10 as default.}

\item{span}{an integer or a vector with integers for the duration of the timespan to be captured}

\item{...}{additional arguments passed to methods}
}
\value{
The number of days required to reach the growing degree days.
}
\description{
Compute number of days required to reach growing degree days.
GDD are calculated by taking the integral of warmth above a base temperature.
}
\examples{
\donttest{

library("ClimMobTools")
library("nasapower")

# random geographic locations around bbox(11, 12, 55, 58)
lonlat <- data.frame(lon = runif(10, 11, 12),
                     lat = runif(10, 55, 58))

# random planting dates around 2018-05-15 and 2018-05-20
pdates <- as.integer(runif(10, 17666, 17670))
pdates <- as.Date(pdates, origin = "1970-01-01")

# Calculate the days required for the plants in these plots to reach the
# maturity. The crop requires ~1800 degree days for it.

GDD(lonlat, 
    day.one = pdates,
    degree.days = 1800,
    base = 5)
}
    
}
