% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA-getDataCM.R, R/as.data.frame-climmob_list.R
\name{getDataCM}
\alias{getDataCM}
\alias{as.data.frame.CM_list}
\title{Get ClimMob data}
\usage{
getDataCM(key, project, as.data.frame = TRUE, server = "climmob3", ...)

\method{as.data.frame}{CM_list}(x, ..., tidynames = TRUE, pivot.wider = FALSE)
}
\arguments{
\item{key}{a character for the user's application programming 
interface (API) key}

\item{project}{a character for the project id}

\item{as.data.frame}{logical, to return a data frame}

\item{server}{optional, a character to select from which server
the data will be retrieved. See details}

\item{...}{additional arguments passed to methods}

\item{x}{an object of class \code{CM_list}}

\item{tidynames}{logical, if \code{TRUE} suppress ODK strings}

\item{pivot.wider}{logical, if \code{TRUE} return a wider object 
where each observer is a row}
}
\value{
An object of class 'CM_list' or a data.frame with class "CM_df" with the 
variables:
\item{id}{the participant's package id}
\item{moment}{the data collection moment}
\item{variable}{the variable name}
\item{value}{the value for each variable}
}
\description{
Fetch the data from a ClimMob project using an application 
 programming interface (API) key
}
\details{
\code{server}: the default server is "climmob" used for clients of 
https://climmob.net/climmob3/, other options are:

 "avisa" for clients of https://avisa.climmob.net/ 
 
 "rtb" for clients of https://rtb.climmob.net/
 
 "testing" for clients of https://testing.climmob.net/climmob3/
}
\examples{
\dontrun{

# This function will not work without an API key  
# the user API key can be obtained once a free ClimMob account 
# is created via https://climmob.net/

my_key <- "add_your_key"
my_project <- "my_climmob_project"

data <- getDataCM(key = my_key, project = my_project)

}

}
\seealso{
ClimMob website \url{https://climmob.net/}

Other GET functions: 
\code{\link{getProjectProgress}()},
\code{\link{getProjectsCM}()}
}
\author{
Kauê de Sousa
}
\concept{GET functions}
