% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpPermuteEntropy.R
\name{cpPermuteEntropy}
\alias{cpPermuteEntropy}
\title{Confidence Intervals Of Entropy Based On Random Permutations Of Network}
\usage{
cpPermuteEntropy(W, cpThreshold.object, n = 100, interval = 0.95,
  CFinder = FALSE)
}
\arguments{
\item{W}{A qgraph object; see also \link[qgraph]{qgraph}}

\item{cpThreshold.object}{A cpThreshold object; see also \link{cpThreshold}}

\item{n}{number of permutations (default is 100)}

\item{interval}{requested confidence interval (larger than zero and smaller 1;
default is 0.95)}

\item{CFinder}{logical indicating whether clique percolation for weighted networks
should be performed as in CFinder ; see also \link{cpAlgorithm}}
}
\value{
A list object with the following elements:
  \describe{
  \item{Confidence.Interval}{a data frame with lower and upper bound of
     confidence interval for each \code{k}}
  \item{Extracted.Rows}{rows extracted from \code{cpThreshold.object} that are
     larger than the upper bound of the specified confidence interval for
     each \code{k}}
}
}
\description{
Function for determining confidence intervals of entropy values calculated for
community partition from clique percolation based on randomly permuted networks
of original network.
}
\details{
The function generates \code{n} random permutations of the network
  specified in \code{W}. For each randomly permuted network, it runs \code{cpThreshold}
  (see \link{cpThreshold} for more information) with \code{k} and \code{I} values
  extracted from the cpThreshold object specified in \code{cpThreshold.object}.
  Across permutations, the confidence intervals of the entropy values are determined
  for each \code{k} separately.

  The confidence interval of the entropy values is determined separately for each \code{k}.
  This is because larger \code{k} have to produce less communities on average,
  which will decrease entropy. Comparing confidence intervals of smaller \code{k} to
  those of larger \code{k} would therefore be disadvantageous for larger \code{k}.

  In the output, one can check the confidence intervals of each \code{k}. Moreover,
  a data frame is produced that takes the cpThreshold object that was specified in
  \code{cpThreshold.object} and removes all rows that do not exceed the upper bound of the
  confidence interval of the respective \code{k}.
}
\examples{
# create qgraph object
W <- matrix(c(0,1,1,1,0,0,0,0,
              0,0,1,1,0,0,0,0,
              0,0,0,0,0,0,0,0,
              0,0,0,0,1,1,1,0,
              0,0,0,0,0,1,1,0,
              0,0,0,0,0,0,1,0,
              0,0,0,0,0,0,0,1,
              0,0,0,0,0,0,0,0), nrow = 8, ncol = 8, byrow = TRUE)
W <- Matrix::forceSymmetric(W)
W <- qgraph::qgraph(W)

# create cpThreshold object
cpThreshold.object <- cpThreshold(W = W, method = "unweighted", k.range = c(3,4),
                                  threshold = "entropy")

# run cpPermuteEntropy with 100 permutations and 95\% confidence interval
\donttest{
set.seed(4186)
results <- cpPermuteEntropy(W = W, cpThreshold.object = cpThreshold.object,
                            n = 100, interval = 0.95)

# check results
results$Confidence.Interval
results$Extracted.Rows
}

}
\author{
Jens Lange, \email{lange.jens@outlook.com}
}
