% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusvis.R
\name{clusvis}
\alias{clusvis}
\title{This function estimates the parameters used for visualization}
\usage{
clusvis(logtik.estim, prop = rep(1/ncol(logtik.estim), ncol(logtik.estim)),
  logtik.obs = NULL, maxit = 10^3, nbrandomInit = 12, nbcpu = 1)
}
\arguments{
\item{logtik.estim}{matrix. It contains the probabilities of classification used for parameter inference (should be sampled from the model parameter or computed from the observations).}

\item{prop}{vector. It contains the class proportions (by default, classes have same proportion).}

\item{logtik.obs}{matrix. It contains the probabilities of classification of the clustered sample. If missing, logtik.estim is used.}

\item{maxit}{numeric. It limits the number of iterations for the Quasi-Newton algorithm (default 1000).}

\item{nbrandomInit}{numeric. It defines the number of random initialization of the Quasi-Newton algorithm.}

\item{nbcpu}{numeric. It specifies the number of CPU (only for linux)}
}
\value{
Returns a list
}
\description{
This function estimates the parameters used for visualization
}
\examples{
\dontrun{
### Package loading
require(Rmixmod)
 
# Data loading (categorical data)
data(birds)

# Model-based clustering with 3 components
resmixmod <- mixmodCluster(birds, 3)

# Inference of the parameters used for results visualization (general approach)
# Probabilities of classification are not sampled from the model parameter,
# but observed probabilities of classification are used for parameter estimation
resvisu <- clusvis(log(resmixmod@bestResult@proba),
                   resmixmod@bestResult@parameters@proportions)


}
}
