% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_n_neigh_k_correspondence}
\alias{plot_n_neigh_k_correspondence}
\title{Relationship Between Number of Nearest Neighbors and Number of Clusters}
\usage{
plot_n_neigh_k_correspondence(nn_object_n_clusters)
}
\arguments{
\item{nn_object_n_clusters}{An object or a concatenation of objects returned by the
`get_nn_importance` method.}
}
\value{
A ggplot2 object with the distributions displayed as boxplots.
}
\description{
Display the distribution of the
number of clusters obtained for each number of neighbors across random seeds.
}
\note{
The number of clusters is displayed on a logarithmic scale.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(runif(100*10), nrow = 100)
rownames(expr_matrix) = as.character(1:100)

nn_importance_obj = get_nn_importance(object = expr_matrix,
    n_neigh_sequence = c(2,5),
    n_repetitions = 5,
    graph_reduction_type = "PCA",
    algorithm = 1,
    transpose = FALSE, # the matrix is already observations x features, so we won't transpose it
    # the following parameter is used by the irlba function and is not mandatory
    nv = 2)
plot_n_neigh_k_correspondence(nn_importance_obj)
}
