% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableFBM.R
\name{TableFBM}
\alias{TableFBM}
\title{Obtainig a table with the interpretable parameters}
\usage{
TableFBM(paramEstimadosFinal, names, E)
}
\arguments{
\item{paramEstimadosFinal}{The estimate parameters, in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}.}

\item{names}{Vector of length D. The component i has the name of the bacteria i.}

\item{E}{Number of bacteria available.}
}
\value{
Returns a table written in latex format.
}
\description{
This function returns a table with the interpretable parameters of the FBM model.
}
\details{
\deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{
paramEstimadosFinal=c(1,2,3,1,2,3,1,2,3)
names=c("Bact1", "Bact2","Bact3")
E=3

TableFBM(paramEstimadosFinal,names,E)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
