% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxnrate.R
\name{rxnrate}
\alias{rxnrate}
\title{Solving the right side of the gLV equations}
\usage{
rxnrate(State, parms)
}
\arguments{
\item{State}{Vector with a CoDa composition}

\item{parms}{Matrix. Each row has the parameters of each differential equation. following our example, parms has the parameters placed as follows:

 \tabular{rrrr}{
 r1 \tab  a11  \tab  a12 \tab   a13 \cr
 r2 \tab  a21 \tab   a22 \tab  a23 \cr
 r3 \tab  a31  \tab  a32 \tab  a33}}
}
\value{
Returns a vector with the value of the right side of the gLV equations.
}
\description{
This function calculates the right side of the gLV equation.
}
\details{
For instance, if we want to solve the following gLV equations:
\deqn{\frac{dx_{1}(t)}{dt}=r_{1}\cdot x_{1}(t)+x_{1}(t)\cdot[a_{11}\cdot x_{1}(t)+a_{12}\cdot x_{2}(t)+a_{13}\cdot x_{3}(t)]}
\deqn{\frac{dx_{2}(t)}{dt}=r_{2}\cdot x_{2}(t)+x_{2}(t)\cdot[a_{21}\cdot x_{1}(t)+a_{22}\cdot x_{2}(t)+a_{23}\cdot x_{3}(t)]}
\deqn{\frac{dx_{3}(t)}{dt}=r_{3}\cdot x_{3}(t)+x_{3}(t)\cdot[a_{31}\cdot x_{1}(t)+a_{32}\cdot x_{2}(t)+a_{33}\cdot x_{3}(t)]}


This function returns a vector with the value of:

\deqn{r_{1}\cdot x_{1}(t)+x_{1}(t)\cdot[a_{11}\cdot x_{1}(t)+a_{12}\cdot x_{2}(t)+a_{13}\cdot x_{3}(t)]}
\deqn{r_{2}\cdot x_{2}(t)+x_{2}(t)\cdot[a_{21}\cdot x_{1}(t)+a_{22}\cdot x_{2}(t)+a_{23}\cdot x_{3}(t)]}
\deqn{r_{3}\cdot x_{3}(t)+x_{3}(t)\cdot[a_{31}\cdot x_{1}(t)+a_{32}\cdot x_{2}(t)+a_{33}\cdot x_{3}(t)]}
}
\examples{


cinit1<-c(x1<-0.7,x2<-0.2,x3<-0.1)
parms1= cbind(c(0.1,0.2,-0.1),c(-0.2,0.1,-0.1),c(0.3,0.2,0.3),c(0.1,0.22,0.2))
rxnrate(cinit1,parms1)

}
