% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoOL_functions.R
\name{CoOL_1_initiate_neural_network}
\alias{CoOL_1_initiate_neural_network}
\title{Initiates a non-negative neural network}
\usage{
CoOL_1_initiate_neural_network(inputs, output, hidden = 10)
}
\arguments{
\item{inputs}{The number of exposures.}

\item{output}{The outbut variable is used to calcualte the mean of it used to initiate the baseline risk.}

\item{hidden}{Number of hidden nodes.}
}
\value{
A list with connection weights, bias weights and meta data.
}
\description{
This function initiates a non-negative neural network. The one-hidden layer non-negative neural network is designed to resemble a DAG with hidden synergistic components. With the model, we intend to learn the various synergistic interactions between the exposures and outcome. The model needs to be non-negative and estimate the risk on an additive scale. Neural networks include hidden activation functions (if the sum of the input exceeds a threshold, information is passed on), which can model minimum threshold values of interactions between exposures. We need to specify the upper limit of the number of possible hidden activation functions and through model fitting, the model may be able to learn both stand-alone and synergistically interacting factors.
}
\details{
The non-negative neural network can be denoted as:
\deqn{
P(Y=1|X^+)=\sum_{j}\Big(w_{j,k}^+ReLU_j\big(\sum_{i}(w_{i,j}^+X_i^+) + b_j^-\big)\Big) + R^{b}
}
}
\examples{
#See the example under CoOL_0_working_example

}
\references{
Rieckmann, Dworzynski, Arras, Lapuschkin, Samek, Arah, Rod, Ekstrom. Causes of outcome learning: A causal inference-inspired machine learning approach to disentangling common combinations of potential causes of a health outcome. medRxiv (2020) <doi:10.1101/2020.12.10.20225243>
}
