% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaPub.R
\name{ctmaPub}
\alias{ctmaPub}
\title{ctmaPub}
\usage{
ctmaPub(
  getPubObj = NULL,
  primaryStudyList = NULL,
  yearsToExclude = 0,
  recency = 5,
  targetYear = NULL,
  indFUN = "sum",
  colFUN = "mean",
  addAsMod = FALSE
)
}
\arguments{
\item{getPubObj}{publication information compiled with \code{\link{ctmaGetPub}}}

\item{primaryStudyList}{vector with numbers of studies (e.g., c(1,3); requires source1 and source3 to be available)}

\item{yearsToExclude}{years to exclude from publications}

\item{recency}{years before targetYear that are considered for recency analysis}

\item{targetYear}{year (default = last year) after which publications are ignored}

\item{indFUN}{function (default = sum) how publications of each author within a collective (team) are summarized}

\item{colFUN}{function (default = mean) how publications all authors of collective (team) are summarized}

\item{addAsMod}{currently disabled. Add to existing moderator objects (or create them) in primaryStudyList, which is part of the returned object}
}
\value{
returns NEPP (= the \*number\* of studies published by the authors of the primary studies supplied UNTIL the year when the
primary study was published), NEPPRecency (like NEPP, but limited to the number of years befor the publication as specified with the
recency argument), "Meaning of NEPP" and "Meaning of NEPPRecency" which explain what \*number\* exactly means (e.g., could be the mean
of the sum of each author's publication, or the sum of the maximum publications per year of the authors), and "primaryStudyList(full)",
which just returns the primaryStudyList supplied).
}
\description{
Compute publication and citation scores for studies based on the (team of) authors' publication scores .
}
\examples{
\donttest{
pubResults_6 <- ctmaPub(getPubObj=pubList_8,
                        primaryStudyList=CoTiMAstudyList_6)
summary(pubResults_6)
}

}
