% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOrphanCodes.R
\name{findOrphanCodes}
\alias{findOrphanCodes}
\title{Find orphan codes related to a codelist}
\usage{
findOrphanCodes(
  x,
  cdm,
  domains = "Condition",
  standardConcept = "Standard",
  searchInSynonyms = TRUE,
  searchNonStandard = TRUE,
  includeDescendants = TRUE,
  includeAncestor = TRUE,
  minCellCount = 5
)
}
\arguments{
\item{x}{Codes for which to find codes related but not included (orphan
codes)}

\item{cdm}{cdm_reference via CDMConnector}

\item{domains}{Character vector with one or more of the OMOP CDM domain.}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{searchInSynonyms}{Either TRUE or FALSE. If TRUE the code will also
search using both the primary name in the concept table and synonyms from
the concept synonym table.}

\item{searchNonStandard}{Either TRUE or FALSE. If TRUE the code will also
search via non-standard concepts.}

\item{includeDescendants}{Either TRUE or FALSE.
If TRUE descendant concepts of identified concepts
will be included in the candidate codelist.}

\item{includeAncestor}{Either TRUE or FALSE.
If TRUE the direct ancestor concepts of identified concepts
will be included in the candidate codelist.}

\item{minCellCount}{The minimum number of counts to reported, below which
results will be suppressed. If 0, all results will be reported.}
}
\value{
A codelist containing code related to (but not in) the target
codelist that are present used in the cdm
}
\description{
Find orphan codes related to a codelist
}
\examples{
\dontrun{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
keywords = "Musculoskeletal disorder",
domains = "Condition",
includeDescendants = FALSE)

orphan_codes <- findOrphanCodes(x = list("msk" = codes$concept_id),
cdm = cdm,
domains = "Condition",
standardConcept = "Standard",
searchInSynonyms = FALSE,
searchNonStandard = FALSE,
includeDescendants = TRUE,
includeAncestor = FALSE)

orphan_codes
CDMConnector::cdmDisconnect(cdm)
}
}
