% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unionCodelists.R
\name{unionCodelists}
\alias{unionCodelists}
\title{Generate a codelist from the union of different codelists. The generated codelist
will come out in alphabetical order.}
\usage{
unionCodelists(x, keepOriginal = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{keepOriginal}{Whether to keep the original codelist (TRUE) or just return
the stratified ones (FALSE).}
}
\value{
A codelist
}
\description{
Generate a codelist from the union of different codelists. The generated codelist
will come out in alphabetical order.
}
\examples{
\donttest{
library(CodelistGenerator)
cdm <- mockVocabRef()
getDrugIngredientCodes(cdm,
                        nameStyle = "{concept_name}") |>
unionCodelists()
}
}
