% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohensdpLibrary.R
\docType{package}
\name{CohensdpLibrary-package}
\alias{CohensdpLibrary}
\alias{CohensdpLibrary-package}
\title{CohensdpLibrary: Cohen's D_p Computation with Confidence Intervals}
\description{
Computing Cohen's d_p in any experimental designs (between-subject, within-subject, and single-group design). Cousineau (2022) <https://github.com/dcousin3/CohensdpLibrary>; Cohen (1969, ISBN: 0-8058-0283-5).
}
\details{
CohensdpLibrary is a library that computes the Cohen's $d_p$ along with confidence intervals. 
Its main contribution is to allow confidence intervals in the repeated-measure designs.
The main function is 

Cohensdp( statistics = list(...), design, gamma, method )  

see help(Cohensdp) for more on this function

It also provides functions
  Hedgesgp( statistics = list(...), design, method )
for an unbiased Cohen's dp and
  J( statistics = list(...), design )
to get the correction factor used in un-biasing dp. 

Subsidiary functions are
plprime(x, nu, ncp) cumulative probability of the lambda prime distribution with parameters nu, ncp
dlprime(x, nu, ncp) density
qlprime(x, nu, ncp) quantile
 
pkprime(x, nu1, nu2, ncp) cumulative probability of the K prime distribution with parameters nu1, nu2, ncp
dkprime(x, nu1, nu2, ncp) density
qkprime(x, nu1, nu2, ncp) quantile
 
These functions are implemented from the FORTRAN source of Poitevineau & Lecoutre, 2010.
Note that the library sadists also has implementations for these two distributions. However,
the sadists::kprime distribution is inaccurate for small nu1 or small nu2.
}
\author{
\strong{Maintainer}: Denis Cousineau \email{denis.cousineau@uottawa.ca} (Developer)

Other contributors:
\itemize{
  \item Douglas Fitts [contributor]
}

}
\keyword{internal}
