% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCharacteristics.R
\name{tableCharacteristics}
\alias{tableCharacteristics}
\title{Format a summarise_characteristics object into a visual table.}
\usage{
tableCharacteristics(
  result,
  type = "gt",
  header = c("cdm_name", "cohort_name"),
  groupColumn = NULL,
  hide = character()
)
}
\arguments{
\item{result}{A summarised_result object. Output of
summariseCharacteristics().}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{tidyColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{tidyColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{tidyColumns(result)}.}
}
\value{
A table with a formatted version of the summariseCharacteristics
result.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

result <- summariseCharacteristics(cdm$cohort1)

tableCharacteristics(result)

mockDisconnect(cdm)
}

}
