% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableLargeScaleCharacteristics.R
\name{tableLargeScaleCharacteristics}
\alias{tableLargeScaleCharacteristics}
\title{Format a summarise_large_scale_characteristics object into a visual table.}
\usage{
tableLargeScaleCharacteristics(
  result,
  topConcepts = NULL,
  type = "gt",
  header = c("cdm_name", "cohort_name", visOmopResults::strataColumns(result),
    "variable_level"),
  groupColumn = c("table_name", "type", "analysis"),
  hide = character()
)
}
\arguments{
\item{result}{A summarised_result object. Output of
summariseLargeScaleCharacteristics().}

\item{topConcepts}{Number of concepts to restrict the table.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{tidyColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{tidyColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{tidyColumns(result)}.}
}
\value{
A formatted table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(DBI)
library(duckdb)
library(CDMConnector)

con <- dbConnect(duckdb(), eunomiaDir())
cdm <- cdmFromCon(con = con, cdmSchema = "main", writeSchema = "main")
cdm <- generateConceptCohortSet(
  cdm = cdm,
  conceptSet = list("viral_pharyngitis" = 4112343),
  name = "my_cohort"
)

result <- summariseLargeScaleCharacteristics(
  cohort = cdm$my_cohort,
  eventInWindow = "condition_occurrence",
  episodeInWindow = "drug_exposure"
)

tableLargeScaleCharacteristics(result)

cdmDisconnect(cdm)
}

}
