% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvival.R
\name{plotSurvival}
\alias{plotSurvival}
\title{Plot survival results}
\usage{
plotSurvival(
  result,
  x = "time",
  xscale = "days",
  ylim = c(0, NA),
  ribbon = TRUE,
  facet = NULL,
  colour = NULL,
  colour_name = NULL
)
}
\arguments{
\item{result}{Survival results}

\item{x}{Variable to plot on x axis}

\item{xscale}{X axis scale. Can be "days" or "years".}

\item{ylim}{Limits for the Y axis}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{colour_name}{Colour legend name}
}
\value{
A plot of survival probabilities over time
}
\description{
Plot survival results
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
plot <- plotSurvival(surv)
plot
}

}
