% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_geo_demographic.R
\name{merge_geo_demographic}
\alias{merge_geo_demographic}
\title{Match and merge geospatial and demographic datasets}
\usage{
merge_geo_demographic(demographic_dataset, simplified = TRUE)
}
\arguments{
\item{demographic_dataset}{character with the demographic dataset name.
Please use \code{list_datasets("demographic", "EN")} or
\code{list_datasets("demographic", "ES")} to check available datasets.}

\item{simplified}{logical for indicating if the downloaded spatial data
should be a simplified version of the geometries. Simplified versions are
lighter but less precise, and are recommended for easier applications like
plots. Default is \code{TRUE}.}
}
\value{
\code{data.frame} object with the merged data.
}
\description{
This function adds the key information of a demographic dataset to a
geospatial dataset based on the spatial aggregation level. Since the smallest
level of spatial aggregation present in the demographic datasets is
municipality, this function can only merge with geospatial datasets that
present municipality or department level.
}
\examples{
\donttest{
merged <- merge_geo_demographic("DANE_CNPVV_2018_9VD", TRUE)
head(merged)
}

}
