% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericToCategorical.R
\name{numericToCategorical}
\alias{numericToCategorical}
\title{numericToCategorical}
\usage{
numericToCategorical(dset, col = "job", resp = "y", bins = 10,
  adjFactor = 0.5)
}
\arguments{
\item{dset}{The data frame containing the data set}

\item{col}{A character respresenting the  name of the numeric attribute which we want to categorize}

\item{resp}{A character respresenting the  name of the binary outcome variable
The binary outcome variable may be a factor with two levels or an integer (or numeric ) with two unique values}

\item{bins}{A number denoting the number of bins.Default value is 10}

\item{adjFactor}{A number or a decimal denoting what is to be added to the number of responses (binary outcome variable is 1 ) or to the number of non responses (binary outcome variable is 0) if either is zero for any level of the attribute}
}
\value{
A list containing the categorized attribute,a table of Information Values for the levels of the categorized attribute,the Information Value for  the entire attribute,a table showing the response rates of the levels of the categorized attribute
}
\description{
This function categorizes a numerical variable by binning
}
\examples{

# Load the German_Credit data set supplied with this package

data("German_Credit")

# Create an empty list

l<-list()

# Call the function as follows.
#This will categorize the numeric variable Duration in the German_Credit dataset.

l<-numericToCategorical(German_Credit,col="Duration",resp="Good_Bad")


# To view the categorized variable

 l$categoricalVariable

 # To view the IV table of the levels of the categorized variable

 l$IVTable

 # To view the total IV value of the  categorized variable

 l$IV

 # To view the response rates of the levels of the categorized variable

 l$collapseLevels

}
