% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Cox_Side_LL_Calc}
\alias{Cox_Side_LL_Calc}
\title{Utility function to perform calculation of Repeated Calculations and Log-Likelihood for Cox Omnibus
\code{Cox_Side_LL_Calc} Called to perform repeated term and risk calculations}
\usage{
Cox_Side_LL_Calc(
  reqrdnum,
  ntime,
  RiskFail,
  RiskGroup_Strata,
  RiskGroup,
  totalnum,
  fir,
  R,
  Rd,
  Rdd,
  Rls1,
  Rls2,
  Rls3,
  Lls1,
  Lls2,
  Lls3,
  cens_weight,
  STRATA_vals,
  beta_0,
  RdR,
  RddR,
  Ll,
  Lld,
  Lldd,
  nthreads,
  debugging,
  KeepConstant,
  ties_method,
  verbose,
  strata_bool,
  CR_bool,
  basic_bool,
  single_bool,
  start,
  iter_stop
)
}
\arguments{
\item{reqrdnum}{total number of free parameters}

\item{ntime}{number of risk groups}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup_Strata}{matrix of strings with rows at risk for each event time and strata}

\item{RiskGroup}{list of string indices for every risk group}

\item{totalnum}{total number of parameters}

\item{fir}{st term number}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{Rls1}{First Risk sum storage}

\item{Rls2}{First Risk sum derivative storage}

\item{Rls3}{First Risk sum second derivative storage}

\item{Lls1}{Second Risk sum storage}

\item{Lls2}{Second Risk sum derivative storage}

\item{Lls3}{Second Risk sum second derivative storage}

\item{cens_weight}{vector of censoring weights}

\item{STRATA_vals}{vector of strata identifier values}

\item{beta_0}{parameter estimates}

\item{RdR}{Risk to first derivative ratio matrix}

\item{RddR}{Risk to second derivative ratio matrix}

\item{Ll}{Log-likelihood vector}

\item{Lld}{Log-likelihood first derivative matrix}

\item{Lldd}{Log-likelihood second derivative matrix}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{ties_method}{Ties method}

\item{verbose}{boolean for additional printing}

\item{strata_bool}{boolean for stratification}

\item{CR_bool}{boolean for competing risks}

\item{basic_bool}{boolean for multiplicative log-linear model}

\item{single_bool}{boolean for single calculation without derivatives}

\item{start}{starting time for regression}

\item{iter_stop}{binary value used to tell the function not to continue iteration}
}
\value{
Updates matrices in place: risk storage matrices
}
\description{
Utility function to perform calculation of Repeated Calculations and Log-Likelihood for Cox Omnibus
\code{Cox_Side_LL_Calc} Called to perform repeated term and risk calculations
}
