% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotTypes.R
\name{PlotCox_Schoenfeld_Residual}
\alias{PlotCox_Schoenfeld_Residual}
\title{Calculates Schoenfeld residuals for a Cox Proportional Hazards regression and plots
\code{RunCox_Schoenfeld_Residual} uses user provided data, time/event columns, vectors specifying the model, and options to calculate the residuals}
\usage{
PlotCox_Schoenfeld_Residual(
  df,
  time1,
  time2,
  event0,
  names,
  Term_n,
  tform,
  keep_constant,
  a_n,
  modelform,
  fir,
  der_iden,
  control,
  age_unit,
  Plot_Name,
  model_control = list()
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{Term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters}

\item{modelform}{string specifying the model type}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter}

\item{control}{list of parameters controlling the convergence}

\item{age_unit}{age unit}

\item{Plot_Name}{plot identifier}

\item{model_control}{controls which alternative model options are used}
}
\value{
saves the plots in the current directory and returns a string that it passed
}
\description{
Calculates Schoenfeld residuals for a Cox Proportional Hazards regression and plots
\code{RunCox_Schoenfeld_Residual} uses user provided data, time/event columns, vectors specifying the model, and options to calculate the residuals
}
