% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Def_modelform_fix}
\alias{Def_modelform_fix}
\title{Automatically assigns geometric-mixture values and checks that a valid modelform is used}
\usage{
Def_modelform_fix(control, model_control, modelform, term_n)
}
\arguments{
\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{term_n}{term numbers for each element of the model}
}
\value{
returns a filled list
}
\description{
\code{Def_model_control} checks and assigns default values for modelform options
}
\examples{
library(data.table)
control <- list("ncores"=2,'lr' = 0.75,'maxiter' = 5, 'ties'='breslow','double_step'=1)
control <- Def_Control(control)
model_control <- list("single"=TRUE)
model_control <- Def_model_control(model_control)
term_n <- c(0,1,1)
modelform <- 'a'
val <- Def_modelform_fix(control,model_control,modelform,term_n)
model_control <- val$model_control
modelform <- val$modelform

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
