% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cox_Regression.R
\name{RunCoxRegression_Omnibus_Multidose}
\alias{RunCoxRegression_Omnibus_Multidose}
\title{Performs Cox Proportional Hazards regression using the omnibus function with multiple column realizations}
\usage{
RunCoxRegression_Omnibus_Multidose(
  df,
  time1 = "start",
  time2 = "end",
  event0 = "event",
  names = c("CONST"),
  term_n = c(0),
  tform = "loglin",
  keep_constant = c(0),
  a_n = c(0),
  modelform = "M",
  fir = 0,
  der_iden = 0,
  realization_columns = matrix(c("temp00", "temp01", "temp10", "temp11"), nrow = 2),
  realization_index = c("temp0", "temp1"),
  control = list(),
  strat_col = "null",
  cens_weight = "null",
  model_control = list(),
  cons_mat = as.matrix(c(0)),
  cons_vec = c(0)
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters. May be either a list of vectors or a single vector.}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter, should be smaller than total number of parameters. indexed starting at 0}

\item{realization_columns}{used for multi-realization regressions. Matrix of column names with rows for each column with realizations, columns for each realization}

\item{realization_index}{used for multi-realization regressions. Vector of column names, one for each column with realizations. each name should be used in the "names" variable in the equation definition}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{strat_col}{column to stratify by if needed}

\item{cens_weight}{column containing the row weights}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}

\item{cons_mat}{Matrix containing coefficients for system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for system of linear constraints, formatted as vector}
}
\value{
returns a list of the final results for each realization
}
\description{
\code{RunCoxRegression_Omnibus_Multidose} uses user provided data, time/event columns,
vectors specifying the model, and options to control the convergence
and starting positions. Used for 2DMC column uncertainty methods.
Returns optimized parameters, log-likelihood, and standard deviation for each realization.
Has additional options for using stratification,
multiplicative loglinear 1-term,
competing risks, and calculation without derivatives
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "t0" = c(18, 20, 18, 19, 21, 20, 18),
  "t1" = c(30, 45, 57, 47, 36, 60, 55),
  "lung" = c(0, 0, 1, 0, 1, 0, 0),
  "dose" = c(0, 1, 1, 0, 1, 0, 1)
)
set.seed(3742)
df$rand <- floor(runif(nrow(df), min = 0, max = 5))
df$rand0 <- floor(runif(nrow(df), min = 0, max = 5))
df$rand1 <- floor(runif(nrow(df), min = 0, max = 5))
df$rand2 <- floor(runif(nrow(df), min = 0, max = 5))
time1 <- "t0"
time2 <- "t1"
names <- c("dose", "rand")
term_n <- c(0, 0)
tform <- c("loglin", "loglin")
realization_columns <- matrix(c("rand0", "rand1", "rand2"), nrow = 1)
realization_index <- c("rand")
keep_constant <- c(1, 0)
a_n <- c(0, 0)
modelform <- "M"
fir <- 0
der_iden <- 0
cens_weight <- c(0)
event <- "lung"
a_n <- c(-0.1, -0.1)
keep_constant <- c(0, 0)
control <- list(
  "ncores" = 2, "lr" = 0.75, "maxiter" = 1,
  "halfmax" = 2, "epsilon" = 1e-6,
  "deriv_epsilon" = 1e-6, "abs_max" = 1.0,
  "change_all" = TRUE, "dose_abs_max" = 100.0,
  "verbose" = 0, "ties" = "breslow", "double_step" = 1
)
e <- RunCoxRegression_Omnibus_Multidose(df, time1, time2, event,
  names,
  term_n = term_n, tform = tform,
  keep_constant = keep_constant, a_n = a_n,
  modelform = modelform, fir = fir, der_iden = der_iden,
  realization_columns = realization_columns,
  realization_index = realization_index,
  control = control, strat_col = "fac",
  model_control = list(), cens_weight = "null"
)
}
\seealso{
Other Cox Wrapper Functions: 
\code{\link{CoxCurveSolver}()},
\code{\link{RunCoxNull}()},
\code{\link{RunCoxRegression}()},
\code{\link{RunCoxRegression_Basic}()},
\code{\link{RunCoxRegression_CR}()},
\code{\link{RunCoxRegression_Guesses_CPP}()},
\code{\link{RunCoxRegression_Omnibus}()},
\code{\link{RunCoxRegression_Single}()},
\code{\link{RunCoxRegression_Strata}()},
\code{\link{RunCoxRegression_Tier_Guesses}()}
}
\concept{Cox Wrapper Functions}
