% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{interact_them}
\alias{interact_them}
\title{Defines Interactions}
\usage{
interact_them(df, interactions, new_names, verbose = 0)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{interactions}{array of strings, each one is of form term1?*?term2" for term1 interaction of type * or + with term2, "?" dlimits}

\item{new_names}{list of new names to use instead of default, default used if entry is ''}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}
}
\value{
returns a list with two named fields. df for the updated dataframe, and cols for the new column names
}
\description{
\code{interact_them} uses user provided interactions define interaction terms and update the data.table. assumes interaction is "+" or "*" and applies basic anti-aliasing to avoid duplicates
}
\examples{
library(data.table)
a <- c(0, 1, 2, 3, 4, 5, 6)
b <- c(1, 2, 3, 4, 5, 6, 7)
c <- c(0, 1, 2, 1, 0, 1, 0)
df <- data.table::data.table("a" = a, "b" = b, "c" = c)
interactions <- c("a?+?b", "a?*?c")
new_names <- c("ab", "ac")
vals <- interact_them(df, interactions, new_names)
df <- vals$df
new_col <- vals$cols
}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Convert_Model_Eq}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Event_Count_Gen}()},
\code{\link{Event_Time_Gen}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()}
}
\concept{Data Cleaning Functions}
