% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_shiny.R
\name{customize_percentile}
\alias{customize_percentile}
\title{Generate Predicted Quantiles for Age Trends}
\usage{
customize_percentile(age_list, feature, q = 0.75, s = "F")
}
\arguments{
\item{age_list}{A list containing all ROIs' true volumes, age trend estimates, and the fitted GAMLSS model.}

\item{feature}{A string specifying the feature of interest within the \code{age_list}.}

\item{q}{A numeric value between 0 and 1 representing the quantile to predict (e.g., \code{0.5} for the median).}

\item{s}{A string indicating the gender of the group for which the predictions are generated (e.g., \code{"F"} for female, \code{"M"} for male).}
}
\value{
A data frame containing columns for age, quantile type, prediction, and sex.
}
\description{
This function computes predicted quantiles for a specified feature and demographic group based on a GAMLSS model.
The function interpolates predictions over a range of ages while accounting for fixed covariates.
}
\details{
This function uses a GAMLSS model to generate predictions for a specified quantile and demographic group.
The predictions are computed over a sequence of ages (\code{age_test}) that spans the observed age range in the data.
The function adjusts for fixed covariates such as \code{icv} by using their mean values from the input data.
}
\examples{
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list <- list("Volume_1" = age_list_gen(sub_df = sub_df))
customize_percentile(age_list, feature = "Volume_1", q = 0.5, s = "F")
}
