/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.InsetsUtil;

public class BorderUtil {
    private BorderUtil() {
    }

    public static Insets getInsetsOutside(Component component, Border border, Border border2) {
        Insets insets = new Insets(0, 0, 0, 0);
        BorderUtil.getInsetsOutside(component, border, border2, insets);
        return insets;
    }

    private static boolean getInsetsOutside(Component component, Border border, Border border2, Insets insets) {
        if (border == null) {
            return false;
        }
        if (border == border2) {
            return true;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            return BorderUtil.getInsetsOutside(component, compoundBorder.getOutsideBorder(), border2, insets) || BorderUtil.getInsetsOutside(component, compoundBorder.getInsideBorder(), border2, insets);
        }
        InsetsUtil.addTo(insets, border.getBorderInsets(component));
        return false;
    }

    public static Border copy(final Border border) {
        return new Border(){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
            }

            public Insets getBorderInsets(Component component) {
                return border.getBorderInsets(component);
            }

            public boolean isBorderOpaque() {
                return border.isBorderOpaque();
            }
        };
    }
}

