% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSH.R
\name{calcSH}
\alias{calcSH}
\title{Calculate Specific Humidity}
\usage{
calcSH(Temp, RH, P_atm = 1013.25, B = 621.9907, ...)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{P_atm}{Atmospheric pressure = 1013.25 (hPa)}

\item{B}{B = 621.9907 g/kg for air}

\item{...}{Additional arguments to supply to \code{\link{calcPws}} and \code{\link{calcMR}}}
}
\value{
SH Specific Humidity (g/kg)
}
\description{
Function to calculate the specific humidity (g/kg) from temperature (°C) and relative humidity (\%).

Specific humidity is the ratio of the mass of water vapor to the mass of air.

Function uses \code{\link{calcMR}}
}
\note{
This function requires the \code{\link{calcMR}} function to be available in the environment.
}
\examples{
calcSH(20, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(SpecificHumidity = calcSH(Temp, RH))



}
\references{
Wallace, J.M. and Hobbs, P.V. (2006). Atmospheric Science: An Introductory Survey.
Academic Press, 2nd edition.
}
\seealso{
\code{\link{calcAD}} for calculating air density

\code{\link{calcAH}} for calculating absolute humidity

\code{\link{calcPw}} for calculating water vapour pressure

\code{\link{calcPws}} for calculating water vapour saturation pressure
}
