\encoding{UTF-8}
\name{DPRHomerangeGravity}
\alias{DPRHomerangeGravity}
\title{Extended DPR population dynamics model to include homerange movement}
\usage{
DPRHomerangeGravity(larval.mat, adult.mat, recruits0, f0, timesteps = 10,
  settler.recruit.func = hockeyStick, LEP.of.f = function(f) 1 - f,
  YPR.of.f = function(f) f, gamma = 0, gravity.ts.interval = 1, ...)
}
\arguments{
  \item{larval.mat}{a square larval connectivity matrix.
  \code{dim(larval.mat) = rep(length(recruits0),2)}}

  \item{adult.mat}{a square adult homerange movement
  matrix.  \code{dim(adult.mat) =
  rep(length(recruits0),2)}. adult.mat must be properly
  normalized so that each column sums to 1.}

  \item{recruits0}{a vector of initial recruitment values
  for each site.}

  \item{f0}{a vector of initial real fishing mortalities
  for each site.}

  \item{timesteps}{a vector of timesteps at which to record
  egg production, settlement and recruitment.}

  \item{settler.recruit.func}{a function to calculate
  recruitment from the number of settlers at each site.
  Defaults to \code{\link{hockeyStick}}.}

  \item{LEP.of.f}{a function that returns
  lifetime-egg-productions given a vector of fishing
  rates.}

  \item{YPR.of.f}{a function that returns
  yields-per-recruit given a vector of fishing rates.}

  \item{gamma}{exponent for the gravity model.  Defaults to
  0, i.e., no gravity model.}

  \item{gravity.ts.interval}{number of timesteps between
  updates of gravity model.  Defaults to 1, i.e., every
  timestep.}

  \item{\dots}{additional arguments to
  settler.recruit.func.}
}
\value{
A list with the following elements:

\item{eggs}{egg production for the timesteps in
\code{timesteps}}

\item{settlers}{Similar for settlement}

\item{recruits}{Similar for recruitment}

\item{fishing.mortality}{Real spatial distribution of
fishing mortality}

\item{effective.fishing.mortality}{Effective fishing
mortality taking into account adult movement}

\item{yield}{Real spatial distribution of yield}

\item{effective.yield}{Effective yield indicating where
fish biomass caught originates from}
}
\description{
This function implements the marine population dynamics
model described in Gruss et al. (2011).  The model is an
extension of the dispersal-per-recruit model in Kaplan et
al. (2006) to include movement in a homerange and a gravity
model for fishing effort redistribution.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\references{
Grüss A, Kaplan DM, Hart DR (2011) Relative Impacts of
Adult Movement, Larval Dispersal and Harvester Movement on
the Effectiveness of Reserve Networks. PLoS ONE 6:e19960

Kaplan, D. M., Botsford, L. W., and Jorgensen, S. 2006.
Dispersal per recruit: An efficient method for assessing
sustainability in marine reserve networks. Ecological
Applications, 16: 2248-2263.
}
\seealso{
See also \code{\link{BevertonHolt}},
\code{\link{hockeyStick}},
\code{\link{DispersalPerRecruitModel}}
}

