% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QVAR.R
\name{QVAR}
\alias{QVAR}
\title{Quantile vector autoregression}
\usage{
QVAR(x, configuration = list(nlag = 1, tau = 0.5))
}
\arguments{
\item{x}{zoo data matrix}

\item{configuration}{model configuration}

\item{nlag}{Lag length}

\item{tau}{quantile between 0 and 1}
}
\value{
Estimate QVAR model
}
\description{
Estimation of a QVAR using equation-by-equation quantile regressions.
}
\examples{
#data(dy2012)
#fit = QVAR(dy2012, configuration=list(nlag=1, tau=0.5))
}
\references{
White, H., Kim, T. H., & Manganelli, S. (2015). VAR for VaR: Measuring tail dependence using multivariate regression quantiles. Journal of Econometrics, 187(1), 169-188.

Chatziantoniou, I., Gabauer, D., & Stenfors, A. (2021). Interest rate swaps and the transmission mechanism of monetary policy: A quantile connectedness approach. Economics Letters, 204, 109891.
}
\author{
David Gabauer
}
