/*
 * Decompiled with CFR 0.152.
 */
package hughes;

import hughes.BinaryTree;
import hughes.DynamicVector;

public class BinarySearchTree
extends BinaryTree {
    protected BSTNode findHelper(BSTNode current, BSTNode target) {
        if (current == null) {
            return null;
        }
        if (target.compareTo(current) < 0) {
            return this.findHelper((BSTNode)current.leftChild, target);
        }
        if (target.compareTo(current) > 0) {
            return this.findHelper((BSTNode)current.rightChild, target);
        }
        return current;
    }

    public Comparable find(Comparable target) {
        BSTNode found = this.findHelper((BSTNode)this.root, new BSTNode(target));
        if (found == null) {
            return null;
        }
        return (Comparable)found.data;
    }

    protected BSTNode insertHelper(BSTNode current, BSTNode newNode) {
        if (current == null) {
            ++this.numItems;
            return newNode;
        }
        if (newNode.compareTo(current) < 0) {
            current.leftChild = this.insertHelper((BSTNode)current.leftChild, newNode);
            current.leftChild.parent = current;
        } else {
            current.rightChild = this.insertHelper((BSTNode)current.rightChild, newNode);
            current.rightChild.parent = current;
        }
        return current;
    }

    public void insert(Comparable newItem) {
        this.root = this.insertHelper((BSTNode)this.root, new BSTNode(newItem));
    }

    protected BSTNode maxHelper(BSTNode current) {
        if (current == null) {
            return null;
        }
        while (current.rightChild != null) {
            current = (BSTNode)current.rightChild;
        }
        return current;
    }

    public Comparable maximum() {
        BSTNode max = this.maxHelper((BSTNode)this.root);
        if (max == null) {
            return null;
        }
        return (Comparable)max.data;
    }

    protected BSTNode minHelper(BSTNode current) {
        if (current == null) {
            return null;
        }
        while (current.leftChild != null) {
            current = (BSTNode)current.leftChild;
        }
        return current;
    }

    public Comparable minimum() {
        BSTNode min = this.minHelper((BSTNode)this.root);
        if (min == null) {
            return null;
        }
        return (Comparable)min.data;
    }

    public Comparable predecessor(Comparable target) {
        BSTNode found = this.findHelper((BSTNode)this.root, new BSTNode(target));
        if (found == null) {
            return null;
        }
        if (found.leftChild != null) {
            return (Comparable)this.maxHelper((BSTNode)((BSTNode)found.leftChild)).data;
        }
        BSTNode parent = (BSTNode)found.parent;
        while (parent != null && parent.compareTo(found) > 0) {
            parent = (BSTNode)parent.parent;
        }
        if (parent == null) {
            return null;
        }
        return (Comparable)parent.data;
    }

    protected BSTNode removeHelper(BSTNode current, BSTNode target) {
        if (current == null) {
            return null;
        }
        if (target.compareTo(current) < 0) {
            current.leftChild = this.removeHelper((BSTNode)current.leftChild, target);
        } else if (target.compareTo(current) > 0) {
            current.rightChild = this.removeHelper((BSTNode)current.rightChild, target);
        } else {
            if (current.isLeaf()) {
                --this.numItems;
                return null;
            }
            if (current.leftChild == null) {
                BSTNode temp = (BSTNode)current.rightChild;
                current.data = temp.data;
                current.leftChild = temp.leftChild;
                if (current.leftChild != null) {
                    current.leftChild.parent = current;
                }
                current.rightChild = temp.rightChild;
                if (current.rightChild != null) {
                    current.rightChild.parent = current;
                }
            } else if (current.rightChild == null) {
                BSTNode temp = (BSTNode)current.leftChild;
                current.data = temp.data;
                current.leftChild = temp.leftChild;
                if (current.leftChild != null) {
                    current.leftChild.parent = current;
                }
                current.rightChild = temp.rightChild;
                if (current.rightChild != null) {
                    current.rightChild.parent = current;
                }
            } else {
                BSTNode temp = (BSTNode)current.rightChild;
                if (temp.isLeaf()) {
                    current.data = temp.data;
                    current.rightChild = null;
                } else if (temp.leftChild == null) {
                    current.data = temp.data;
                    current.rightChild = temp.rightChild;
                    if (current.rightChild != null) {
                        current.rightChild.parent = current;
                    }
                } else {
                    while (temp.leftChild.leftChild != null) {
                        temp = (BSTNode)temp.leftChild;
                    }
                    current.data = temp.leftChild.data;
                    this.removeHelper(temp, new BSTNode((Comparable)temp.leftChild.data));
                    ++this.numItems;
                }
            }
            --this.numItems;
        }
        return current;
    }

    public void remove(Comparable target) {
        this.root = this.removeHelper((BSTNode)this.root, new BSTNode(target));
    }

    public Comparable successor(Comparable target) {
        BSTNode found = this.findHelper((BSTNode)this.root, new BSTNode(target));
        if (found == null) {
            return null;
        }
        if (found.rightChild != null) {
            return (Comparable)this.minHelper((BSTNode)((BSTNode)found.rightChild)).data;
        }
        BSTNode parent = (BSTNode)found.parent;
        while (parent != null && parent.compareTo(found) <= 0) {
            parent = (BSTNode)parent.parent;
        }
        if (parent == null) {
            return null;
        }
        return (Comparable)parent.data;
    }

    protected void treeToVine() {
        class NodeCollector
        implements BinaryTree.NodeProcessor {
            DynamicVector nodes;

            NodeCollector() {
                this.nodes = new DynamicVector(BinarySearchTree.this.size());
            }

            public void processNode(BinaryTree.BinaryTreeNode node) {
                if (node == null) {
                    return;
                }
                this.nodes.append(node);
            }
        }
        NodeCollector collect = new NodeCollector();
        this.inorderTraverse(collect);
        BinaryTree.BinaryTreeNode parent = null;
        for (int j = 0; j < this.size() - 1; ++j) {
            BinaryTree.BinaryTreeNode current = (BinaryTree.BinaryTreeNode)collect.nodes.elementAt(j);
            current.parent = parent;
            if (parent != null) {
                parent.rightChild = current;
            }
            current.leftChild = null;
            parent = current;
        }
        this.root = (BinaryTree.BinaryTreeNode)collect.nodes.elementAt(0);
    }

    protected void compression(BinaryTree.BinaryTreeNode node, int count) {
        BinaryTree.BinaryTreeNode scanner = node;
        for (int j = 0; j < count; ++j) {
            BinaryTree.BinaryTreeNode child = scanner.rightChild;
            scanner.rightChild = child.rightChild;
            if (scanner.rightChild != null) {
                scanner.rightChild.parent = scanner;
            }
            scanner = scanner.rightChild;
            child.rightChild = scanner.leftChild;
            if (child.rightChild != null) {
                child.rightChild.parent = child;
            }
            scanner.leftChild = child;
            child.parent = scanner;
        }
    }

    protected void vineToTree() {
        BSTNode dummyRoot = new BSTNode(null);
        dummyRoot.rightChild = (BinaryTree.BinaryTreeNode)this.root;
        int n = this.size() - 1;
        int m = n / 2;
        while (m > 0) {
            this.compression(dummyRoot, m);
            n = n - m - 1;
            m = n / 2;
        }
        this.root = dummyRoot.rightChild;
        ((BinaryTree.BinaryTreeNode)this.root).parent = null;
    }

    public void balance() {
        this.treeToVine();
        this.vineToTree();
    }

    public static class BSTNode
    extends BinaryTree.BinaryTreeNode
    implements Comparable {
        public BSTNode(Comparable dat) {
            super(dat);
        }

        public BSTNode(Comparable dat, BSTNode lc, BSTNode rc, BSTNode par) {
            super(dat, lc, rc, par);
        }

        public int compareTo(Object o) {
            Comparable c = (Comparable)((BSTNode)o).data;
            return ((Comparable)this.data).compareTo(c);
        }
    }
}

