#' @name isDegenerateGame
#' @title Check if game is degenerate
#' @description Checks if a TU game is degenerate.
#' We call a game essential if the value of the grand coalition is    
#' greater than the sum of the values of the singleton coalitions.
#' We call a game degenerate (or inessential), if \deqn{v(N) = \sum v({i})}.
#' @aliases isDegenerateGame isInEssentialGame isInessentialGame
#' @export isDegenerateGame
#' @template author/MM
#' @template author/JS
#' @template param/v
#' @return \code{TRUE} if the game is degenerate, else \code{FALSE}
#' @examples
#' library(CoopGame)
#' isDegenerateGame(c(1,2,3,4,4,4,6))
#' 
#' \donttest{
#' #The following game, i.e. the Maschler game, is not degenerate
#' library(CoopGame)
#' v1 <- c(0,0,0,60,60,60,72)
#' isDegenerateGame(v1) 
#'
#' #The following game is also not degenerate
#' library(CoopGame)
#' v2 <- c(30,30,15,60,60,60,72)
#' isDegenerateGame(v2)
#'
#' #The following game is degenerate
#' library(CoopGame)
#' v3 <- c(20,20,32,60,60,60,72)
#' isDegenerateGame(v3)
#' }
#' 
isDegenerateGame<-function(v){
  paramCheckResult=getEmptyParamCheckResult()
  initialParamCheck_isDegenerateGame(paramCheckResult = paramCheckResult, v)
  A = v
  #get number of players
  numberOfPlayers <- getNumberOfPlayers(A)

  isDegenerate <- FALSE

  # sum up values for singleton coalitions and get value generated by the grand coalition
  scVal <- sum(A[1:numberOfPlayers])

  gcVal <- A[length(A)]

  if(gcVal == scVal) {
    isDegenerate <- TRUE
  } 
  return(isDegenerate)
}

initialParamCheck_isDegenerateGame=function(paramCheckResult,v=v){
  stopOnInvalidGameVector(paramCheckResult, v)
}