% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidGameVector}
\alias{stopOnInvalidGameVector}
\title{Parameter Function stopOnInvalidGameVector}
\usage{
stopOnInvalidGameVector(paramCheckResult, v, n = NULL)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{n}{represents the number of players}
}
\description{
stopOnInvalidGameVector checks if game vector v 
 is specified correctly.
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes calculation to stop.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1000 \tab Game vector is invalid as 'NULL' \cr
1001 \tab Number of elements in game vector is invalid \cr
1002 \tab Type of game vector is not numeric \cr
1003 \tab Game vector has different number of players than n \cr
1004 \tab Null game specified, value for every player is 0 }
}

\examples{
library(CoopGame)
validGameVector=c(0,0,0,60,60,60,72)
stopOnInvalidGameVector(paramCheckResult,validGameVector)
}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
