% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licenses.R
\name{cds_accept_licence}
\alias{cds_accept_licence}
\title{Accept a specific licence}
\usage{
cds_accept_licence(license, revision, ..., token = cds_get_token())
}
\arguments{
\item{license}{The license id you wish to accept.}

\item{revision}{The revision number of the license you are accepting.
Should always be the latest revision.}

\item{...}{Ignored}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
Returns a \code{data.frame} containing the accepted license
}
\description{
Call this function if you wish to accept a specific license.
}
\examples{
if (interactive() && cds_token_works()) {
  cds_accept_licence("cc-by", 1)
}
}
